#ifndef RXEVENT_H
#define RXEVENT_H

#include "event.h"

template <class T>
class RxEvent : public Event
{
    protected:
        void (T:: * m_pAction)();
        T * m_pObjAction;
        char m_cNumEvent;
        char m_cNumJoueur;
    public:
        RxEvent() {}
        RxEvent(char numJoueur, char numEvent, T * pObjAction, void (T:: * pAction)()):
                m_pObjAction(pObjAction), m_pAction(pAction), m_cNumJoueur(numJoueur), m_cNumEvent(numEvent) {}
        virtual void tester();
        void setNumJoueur( char numJoueur) {m_cNumJoueur = numJoueur ; }
        void setNumEvent( char numEvent) {m_cNumEvent = numEvent ; }
        void setAction( T * pObjAction, void (T:: * pAction)() )
                {m_pAction=pAction ; m_pObjAction=pObjAction; }
};

template <class T>
void RxEvent<T>::tester()
{
    if (g_SGReseau.testEvent(this->m_cNumJoueur, this->m_cNumEvent))
    {
        (m_pObjAction->*m_pAction)();
    }
}

#endif
